import tkinter as tk
import random


def toon_telefoonnummer():
    ingevuld_telefoonnummer = ""

    if invoermethode_var.get() == "Invoerveld":
        ingevuld_telefoonnummer = invoerveld.get()
    elif invoermethode_var.get() == "Spinbox":
        ingevuld_telefoonnummer = spinbox.get()
    elif invoermethode_var.get() == "Schaal":
        ingevuld_telefoonnummer = scaleslider.get()
    elif invoermethode_var.get() == "Verhoog":
        ingevuld_telefoonnummer = telefoonnummer_label.cget('text')
    elif invoermethode_var.get() == "Controle":
        ingevuld_telefoonnummer = controle_label.cget('text')
    elif invoermethode_var.get() == "ASCII":
        try:
            ascii_waarden = ascii_entry.get().split()
            ingevuld_telefoonnummer = "".join(chr(int(waarde)) for waarde in ascii_waarden)
        except ValueError:
            ingevuld_telefoonnummer = "Ongeldige ASCII-waarden"

    resultaat_label.config(text=f"Je ingevoerde telefoonnummer is: {ingevuld_telefoonnummer}")


def verhoog_telefoonnummer():
    huidig_telefoonnummer = int(telefoonnummer_label.config('text')[-1])
    nieuw_telefoonnummer = huidig_telefoonnummer + 1
    telefoonnummer_label.config(text=str(nieuw_telefoonnummer))


def toon_willekeurig_telefoonnummer():
    willekeurig_telefoonnummer = random.randint(1000000000, 9999999999)
    controle_label.config(text=f"Is dit jouw nummer? {willekeurig_telefoonnummer}")


app = tk.Tk()
app.title("Telefoonnummer Formulier")
app.geometry("400x800")

invoermethode_var = tk.StringVar()
invoermethode_var.set("Invoerveld")

invoermethode_label = tk.Label(app, text="Kies een invoermethode:")
invoermethode_label.pack(pady=10)

invoermethode_radiobuttons = [
    tk.Radiobutton(app, text="Invoerveld", variable=invoermethode_var, value="Invoerveld"),
    tk.Radiobutton(app, text="Spinbox", variable=invoermethode_var, value="Spinbox"),
    tk.Radiobutton(app, text="Schaal", variable=invoermethode_var, value="Schaal"),
    tk.Radiobutton(app, text="Verhoog met + knop", variable=invoermethode_var, value="Verhoog"),
    tk.Radiobutton(app, text="Controle", variable=invoermethode_var, value="Controle"),
    tk.Radiobutton(app, text="ASCII", variable=invoermethode_var, value="ASCII")

]

for radiobutton in invoermethode_radiobuttons:
    radiobutton.pack()

invoerveld = tk.Entry(app)
invoerveld.pack(pady=10)

spinbox = tk.Spinbox(app, from_=0, to=9999999999)
spinbox.pack(pady=10)

scaleslider = tk.Scale(app, from_=0, to=9999999999, orient="horizontal")
scaleslider.pack(pady=10)

telefoonnummer_label = tk.Label(app, text="0")
telefoonnummer_label.pack(pady=10)

verhoog_knop = tk.Button(app, text="+", command=verhoog_telefoonnummer)
verhoog_knop.pack(pady=10)

controle_label = tk.Label(app, text=f"Is dit jouw nummer? {random.randint(1000000000, 9999999999)}")
controle_label.pack(pady=10)

willekeurig_knop = tk.Button(app, text="Dit is niet mijn nummer", command=toon_willekeurig_telefoonnummer)
willekeurig_knop.pack(pady=10)

ascii_entry_label = tk.Label(app, text="Voer een ASCII-waarde in:")
ascii_entry_label.pack(pady=10)

ascii_entry = tk.Entry(app)
ascii_entry.pack(pady=10)

verzend_button = tk.Button(app, text="Toon telefoonnummer", command=toon_telefoonnummer)
verzend_button.pack(pady=10)

resultaat_label = tk.Label(app, text="")
resultaat_label.pack(pady=10)

app.mainloop()